# CopyRight Dustin Nelson 2010-2024. Please do not distribute
# https://www.rapidrig.com
# Plug-in for Modular Character Rigging Nodes.

"""
Rapid Rig Modular (RRM) is for production and personal use only.
RRM rigs, in whole or in part, or any of the RRM code is not to be distributed outside of a production.
RRM is not to be used for rigging models intended for sale, trade or any other distribution.
"""

# version #, eg 2024, is set up through the PackageContents.xml, this file needs to be update with each Maya release

from importlib import reload
import sys

import inspect
import maya.cmds as cmds

import maya.api as OpenMayaApi
# from maya import OpenMayaMPx
import maya.OpenMaya as OpenMayaOld
import maya.api.OpenMaya as OpenMaya
# import maya.api.OpenMayaMPx as OpenMayaMPx
import maya.OpenMayaMPx as OpenMayaMPx

dir_path = inspect.getfile(lambda: None)
rrm3_path = dir_path.rsplit('rrm3_nodes', 1)[0]
print('rrm3_path', rrm3_path)


if rrm3_path not in sys.path:
    sys.path.append(rrm3_path)


from rrm3_nodes.Contents.scripts.build_nodes import math_nodes

maya_useNewAPI = True

rrm3_math_nodes = [math_nodes.RRM3FloatMultNode, math_nodes.RRM3FloatDivNode,
                   math_nodes.RRM3FloatAddNode, math_nodes.RRM3FloatSubtractNode,
                   math_nodes.RRM3Vec3MultNode, math_nodes.RRM3Vec3DivNode,
                   math_nodes.RRM3Vec3AddNode, math_nodes.RRM3Vec3SubtractNode,
                   ]

def initializePlugin(m_object_plugin):
    """ initialize plugin """
    fn_plugin = OpenMaya.MFnPlugin(m_object_plugin, 'RRM3 Nodes', '3.00.00', 'Any')

    try:
        # import math nodes
        for rrm3_math_node in rrm3_math_nodes:
            fn_plugin.registerNode(rrm3_math_node.TYPE_NAME,
                                   rrm3_math_node.TYPE_ID,
                                   rrm3_math_node.creator,
                                   rrm3_math_node.initialize,
                                   OpenMaya.MPxNode.kDependNode)

        print('Rapid Rig Modular V3 Nodes successfully loaded.')
    except RuntimeError as err:
        # math nodes
        for rrm3_math_node in rrm3_math_nodes:
            print(f'failed to initialize plugin: {rrm3_math_node.TYPE_NAME}')
        raise RuntimeError("Failed to register nodes: {}".format(err))


def uninitializePlugin(plugin):
    """ un-initialize plugin """
    fn_plugin = OpenMaya.MFnPlugin(plugin)

    try:
        for rrm3_math_node in rrm3_math_nodes:
            fn_plugin.deregisterNode(rrm3_math_node.TYPE_ID)\

        print('Rapid Rig Modular V3 Nodes plugin successfully un-initialized.')

    except RuntimeError as err:
        for rrm3_math_node in rrm3_math_nodes:
            print(f'Failed to un-initialize plugin: {rrm3_math_node.TYPE_NAME}')
        raise RuntimeError("Failed to deregister nodes: {}".format(err))

